<?php

use yii\helpers\Html;
use yii\helpers\Url;

?>
<section class="content margin">

    <div class="tours">
        <?php foreach ($tours as $tour): ?>
            <div class="tour">
            <img class="tour-image" src="<?php echo Yii::getAlias('@web') ?>/imgs/<?php echo $tour['image'] ?>">
            <!--            <img class="tour-image" src="--><?php //= Html::encode($tour->image) ?><!--">-->
            <div class="tour-info">
                <h3 class="tour-title"><?= Html::encode($tour->name) ?> (<?= Html::encode($tour->city) ?>)</h3>
                <p class="tour-text"><?= $tour->days ?> Дней</p>
            </div>
            <div class="tour-more">
                <p>Стоимость: $<?= $tour->price ?></p>
                <a class="tour-link" href="<?= Url::to(['country/tourview', 'id' => $tour->id]) ?>"><button class="tour-button">Подробнее</button></a> </div>
            </div><?php endforeach; ?>
    </div>
</section>